// SendLetterViaHAThread.java
// Both 14 feb

import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import Globals;

public class SendLetterViaHAThread extends Thread {
  public Letter2 L;
  private int startX, startY, endX, endY, x ,y;
  Graphics g;
  ShowMobileIPCanvas canvas;
  Agent sender;
  
  public void start(Agent sender,ShowMobileIPCanvas father) {
    this.canvas = father; 
    this.startX = sender.x; this.startY = sender.y; 
    this.endX = Globals.FA[0].x; this.endY = Globals.FA[0].y; 
    this.x = sender.x; this.y = sender.y;
    this.sender =sender;
    L = new Letter2(canvas);
    g = canvas.getGraphics();
    super.start(); // run() MUST be started from Thread.start()
  }
  
  public void run() {
    // Print first message
    canvas.frame.textArea1.appendHiLit(canvas.viaHAText1);
    Globals.actionAllowed = false; // MH interaction disabled
    L.drawLetter(g, startX, startY); 
    canvas.frame.setCont();
    // Define letter informationText
    L.info =  "Contains data to MH";
    run1(endX, endY);
    canvas.frame.textArea1.appendHiLit(canvas.viaHAText2);
    pause(Globals.pauseTime);
    if (Globals.MH.connected == Globals.FA[0])  // Is MH at HA?
      // Sends letter from HA to MH registered at HA      
      canvas.sendLetter(sender, Globals.FA[0]); 
    else if (Globals.MH.connected != null) { // tunnling
      L.eraseLetter(g);
      canvas.sendLetterTunnel(Globals.FA[0]);
      suspend();
      canvas.updateFA(sender);
    }
    else 
      canvas.warningLetter(sender);
    stop(); // Make the Thread disappear
  } // end run()

   // Animation of Letter
  private void run1(int toX, int toY) {
    int biggest = Math.max(Math.abs(toY - y), Math.abs(toX - x));
    float dx = (float) (toX - x) / biggest;
    float dy = (float) (toY - y) / biggest;
    float xtemp = (float) x;
    float ytemp = (float) y; 
    float minToY = toY - Math.abs(dy), maxToY = toY + Math.abs(dy);
    float minToX = toX - Math.abs(dx), maxToX = toX + Math.abs(dx);
  
    // while ((x != toX) && (y != toY)) { 
    while (!(((ytemp < maxToY) && (ytemp > minToY)) && 
	     ((xtemp < maxToX) && (xtemp > minToX)))) {
      if (Globals.contAllowed) { // Check whether user pressed Stop 
     	xtemp  = xtemp+dx;
	ytemp  = ytemp+dy;
	g.setColor(Color.lightGray);
	g.fillRect(x-1, y-1, 22, 14);
	x = (int) xtemp;
	y = (int) ytemp;
	canvas.paint(g); 
	L.drawLetter(g, x, y); 
	 try {  
	  sleep(Globals.sleepTime);
	 } catch (InterruptedException e) {break;}
      }
      else { // Wait for user to press continue
	canvas.frame.setStop(); // Activate Stopbutton
	this.suspend();
      }
    } // end while   
  } 
    
  public void pause(int time) {
    try {  
      Thread.sleep(time);
    } catch (InterruptedException e) {}
  }
}
	
